var samplePageObj = {
  // 샘플 타이틀
  title: 'Events 예제',
  subtitle: '시트에서 제공하는 다양한 이벤트와 발생 순서를 확인해 봅니다.',
  // 샘플 설명
  desc: '데이터 로드나 값의 수정,포커스 이동, 마우스 오버등 다양한 이벤트가 발생할때 마다 시간과 순서를 확인해 봅니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      ShowFilter: 1,
      SearchMode: 1,
      InfoRowConfig: {
        Visible: 1,
        Space: 'Bottom',
        Layout: [
          'Paging',
          ''
        ]
      },
      GroupMain: 'EMP_NO',
      // GroupFormat:" <span style='color:red'>{%s}</span> <span style='color:blue'>({%c}건)</span>",
      // GroupMain: "EMP_NO",
      FitWidth: 1,
      CanDrag: 1,
      LongClick: 1000,
    },

    // 그룹행 설정
    Solid: [
      {
        Kind: 'Group',
        Space: 0,
        id: 'Group'
      }
    ],
    // 행,열 단위 공통 기능 설정
    Def: {
      Row: {
        ShowHint: 1,
        Tip: 1
      },
      Col: {
        RelWidth: 1,
        GroupWidth: 210
      }
    },
    LeftCols: [
      {
        Header: ['NO.'],
        Name: 'SEQ',
        MaxWidth: 50
      }
    ],
    Cols: [
      {
        Header: ['ID'],
        Name: 'EMP_NO',
        Type: 'Text',
        Align: 'center',
        Width: 70,
        RelWidth: 0,
        CanGroup: false
      },
      {
        Header: ['성'],
        Name: 'FIRST_NAME',
        CanGroup: false,
        Icon: '../assets/imgs/popup.png'
      },
      {
        Header: ['이름'],
        Name: 'LAST_NAME',
        Button: 'Button',
        ButtonText: '눌러',
        WidthPad: 50,
        CanGroup: false
      },
      {
        Header: ['부서'],
        Name: 'DEPT_NO',
        Type: 'Enum',
        Enum: '|인사|총무|회계|경리|설계1|설계2|시공1|시공2|감리',
        EnumKeys: '|d001|d002|d003|d004|d005|d006|d007|d008|d009'
      },
      {
        Header: ['직급'],
        Name: 'POSITION',
        Type: 'Text',
        Button: 'Defaults',
        Defaults: '|사장|부자장|전무|상무|이사|부장|차장|과장|대리|주임|사원|단기계약|장기계약'
      },
      {
        Header: ['성별'],
        Name: 'GENDER',
        Type: 'Enum',
        Enum: '|남자|여자',
        EnumKeys: '|M|F',
        Width: 60,
        RelWidth: 0
      },
      {
        Header: ['생년월일'],
        Name: 'BIRTH_DATE',
        Extend: IB_Preset.YMD
      },
      {
        Header: ['고용일'],
        Name: 'HIRE_DATE',
        Extend: IB_Preset.YMD
      },
      {
        Header: ['급여'],
        Name: 'SALARY',
        Type: 'Int',
        Format: '$#,###'
      },
      {
        Header: ['홈페이지'],
        Name: 'HOMEPAGE',
        Type: 'Link',
        CanEdit: 0
      },
      {
        Header: ['FROM_DATE'],
        Name: 'FROM_DATE',
        Extend: IB_Preset.YMD,
        Visible: false
      },
      {
        Header: ['TO_DATE'],
        Name: 'TO_DATE',
        Extend: IB_Preset.YMD,
        Visible: false
      },
      {
        Header: ['DEPT_NAME'],
        Name: 'DEPT_NAME',
        CanGroup: false,
        Visible: false
      },
      {
        Header: ['RN'],
        Name: 'RN',
        CanGroup: false,
        Visible: false
      },
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><label class=\'mgr50\'>Event logs</label><button type=\'button\' class=\'mgb10 mgr30\' onclick=\'sampleBtn(this)\'>로그 지우기</button><hr>'
  + '<input type=\'checkbox\' id=\'showKBevt\' ><label class=\'mgr10\'>키보드 이벤트 표시</label><input type=\'checkbox\' id=\'showMOSevt\' ><label>마우스 이벤트 표시</label><br>'
  + '<textarea id=\'logs\' style=\'width:100%;height:100px;padding:2px 0px 2px 5px\'></textarea></div>'
  + '<div><button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>한행 추가</button><button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>5개 행 추가</button>'
  + '<button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>행 복사</button><button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>행 삭제</button><hr>'
  + '<button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>데이터 조회</button><button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>데이터 저장</button><hr>'
  + '</div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function (obj) {
    switch (obj.textContent) {
      case '로그 지우기':
        document.getElementById('logs').value = '';
        samplePageObj.cnt = 1;
        break;
      case '한행 추가':
        sheet.addRow({ visible: 1 });
        break;
      case '5개 행 추가':
        sheet.addRows({
          count: 5,
          visible: 1
        });
        break;
      case '행 복사':
        sheet.copyRow({
          row: sheet.getFocusedRow(),
          next: sheet.getNextRow(sheet.getFocusedRow())
        });
        break;
      case '행 삭제':
        sheet.deleteRow(sheet.getFocusedRow());
        break;
      case '데이터 조회':
        sheet.loadSearchData(samplePageObj.data);
        break;
      case '데이터 저장':
        var url = '/samples/customer/save_success.jsp';

        if (location.href.indexOf('localhost') > -1) {
          url = '../jsp' + url;
        } else {
          url = 'https://api.ibleaders.com/ibsheet/v8' + url;
        }
        sheet.doSave(url, 'EMPNO=9812321&EMPNM=CHRIS');
        break;
      // no default
    }
  },
  externalFunction: {
    count: function () {
      if (typeof samplePageObj.Cnt == 'undefined') { samplePageObj.Cnt = 0; } else { samplePageObj.Cnt++; }

      return samplePageObj.Cnt;
    }
  },
  // event구문
  event: {
    onAfterChange: function (evtParam) {
      // 셀값 수정후 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
          + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onAfterClick: function (evtParam) {
      // 셀 클릭시 맨 마지막에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
          + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },

    onAfterColMove: function (evtParam) {
      // 컬럼 이동시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
          + '\t\t\t발생 위치 : ' + (evtParam.row ? evtParam.row.HasIndex + ' 행,' : '') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onAfterColResize: function (evtParam) {
      // 컬럼의 너비 변경시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
          + '\t\t\t발생 위치 : ' + (evtParam.row ? evtParam.row.id + ' 행,' : '') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onAfterEdit: function (evtParam) {
      // 편집 종료 후에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
          + '\t\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : '') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onAfterFilter: function (evtParam) {
      // 필터값 적용완료 후 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName + '\n' + document.getElementById('logs').value;
    },
    onAfterGotoPage: function (evtParam) {
      // 페이지 이동시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName + '\n' + document.getElementById('logs').value;
    },
    onAfterGroup: function (evtParam) {
      // 그룹핑 완료후 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName + '\n' + document.getElementById('logs').value;
    },
    onAfterRowAdd: function (evtParam) {
      // addRows나 copyRows 함수를 통해 여러개 행이 추가될 때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행\n' : '\n') + document.getElementById('logs').value;
    },
    onAfterRowCopy: function (evtParam) {
      // copyRow,copyRows 함수를 통해 행이 복사될때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t원본 행 : ' + (evtParam.row ? evtParam.source.HasIndex + ' 행\n' : '\n') + document.getElementById('logs').value;
    },
    onAfterRowDelete: function (evtParam) {
      // deleteRow 함수를 통해 행의 상태가 삭제로 변경될 때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행\n' : '\n') + document.getElementById('logs').value;
    },
    onAfterRowMoveToSheet: function (evtParam) {
      // 드래그를 통해 서로 다른 시트간에 데이터 이동시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행\n' : '\n') + document.getElementById('logs').value;
    },
    onAfterRowMove: function (evtParam) {
      // 드래그를 통한 시트내에 행 이동시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행\n' : '\n') + document.getElementById('logs').value;
    },
    onAfterSave: function (evtParam) {
      // 저장 작업이 완료된 이후에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t저장 결과 : ' + evtParam.result + '\n' + document.getElementById('logs').value;
    },
    onAfterSort: function (evtParam) {
      // 헤더 클릭을 통한 소팅 완료시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName + '\n' + document.getElementById('logs').value;
    },
    onBeforeChange: function (evtParam) {
      // 셀값 수정 전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
          + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onBeforeDataLoad: function (evtParam) {
      // doSearch,loadSearchData 와 같은 함수를 통해 데이터 로딩 전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t로딩 데이터 건수 : ' + evtParam.data.length + '\n' + document.getElementById('logs').value;
    },
    onBeforeFilter: function (evtParam) {
      // 필터값 적용 직전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName + '\n' + document.getElementById('logs').value;
    },
    onBeforeGoToPage: function (evtParam) {
      // 페이지 이동 전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t이동할 페이지 : ' + evtParam.pagepos + '\n' + document.getElementById('logs').value;
    },
    onBeforeGroup: function (evtParam) {
      // 그룹핑 실행 전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName + '\n' + document.getElementById('logs').value;
    },
    onBeforeRowDelete: function (evtParam) {
      // deleteRow 함수를 통해 행의 상태가 삭제로 변경되기 전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행\n' : '\n') + document.getElementById('logs').value;
    },
    onBeforeSave: function (evtParam) {
      // 저장 작업 처리 전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t저장할 데이터 : ' + evtParam.source.Params + '\n' + document.getElementById('logs').value;
    },

    onBeforeSort: function (evtParam) {
      // 소팅 작업 전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t소팅할 컬럼 : ' + evtParam.col + '\n' + document.getElementById('logs').value;
    },
    onBlur: function (evtParam) {
      // blur함수를 통해 현재 포커스를 제거하는 경우 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.orow.HasIndex ? evtParam.orow.HasIndex + ' 행,' : evtParam.orow.Kind + ' 행,') + (evtParam.ocol ? evtParam.ocol + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onButtonClick: function (evtParam) {
      // Button 속성으로 만든 버튼이 눌려질때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onCanDrop: function (evtParam) {
      // 행을 드래그하다 드롭 직전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t원본행 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,드롭할 위치 : ' : evtParam.row.id + ' 행,드롭할 위치 : ') + (evtParam.torow ? evtParam.torow.HasIndex + ' 행\n' : evtParam.torow.id + '행\n') + document.getElementById('logs').value;
    },
    onClick: function (evtParam) {
      // 시트 내에서 클릭시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
       + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onColResize: function (evtParam) {
      // 컬럼사이즈 변경시 발생합니다.
      // document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      //  + '\t\t\t발생 위치 : ' + evtParam.col + ' 열\n' + document.getElementById('logs').value;
    },
    onDataLoad: function (evtParam) {
      // 시트에 들어간 데이터가 파싱되어 로드된 후에 발생합니다. (데이터는 파싱되었으나 화면에 반영되는 렌더링 전입니다.)
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName + '\n' + document.getElementById('logs').value;
    },
    onDblClick: function (evtParam) {
      // 시트 내에서 더블 클릭시 발생합니다.
      if (evtParam.row) {
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
         + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
      }
    },
    onEndDrag: function (evtParam) {
      // 행을 드래그하다 드롭 후에 발생합니다.
      if (evtParam.row && evtParam.torow) {
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
          + '\t\t\t원본행 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,드롭할 위치 : ' : evtParam.row.id + ' 행,드롭할 위치 : ') + (evtParam.torow ? evtParam.torow.HasIndex + ' 행\n' : evtParam.torow.id + '행\n') + document.getElementById('logs').value;
      }
    },
    onEndEdit: function (evtParam) {
      // 편집 종료 전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : '') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onFocus: function (evtParam) {
      // 시트 내에 포커스가 이동할때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t이전 위치 : ' + (evtParam.orow ? evtParam.orow.HasIndex + ' 행,' : '없음,') + (evtParam.ocol ? evtParam.ocol + ' 열' : '없음')
      + '\t현재 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onIconClick: function (evtParam) {
      // 셀 왼쪽 아이콘을 클릭시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : '') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    // onImportFinish:function(evtParam){

    // },
    onKeyDown: function (evtParam) {
      if (document.getElementById('showKBevt').checked) {
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t\t눌린 키 : ' + evtParam.name + '  keyCode : ' + evtParam.key + '\n' + document.getElementById('logs').value;
      }
    },
    onKeyPress: function (evtParam) {
      if (document.getElementById('showKBevt').checked) {
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t\t눌린 키 : ' + evtParam.name + '  keyCode : ' + evtParam.key + '\n' + document.getElementById('logs').value;
      }
    },
    onKeyUp: function (evtParam) {
      if (document.getElementById('showKBevt').checked) {
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t\t눌린 키 : ' + evtParam.name + '  keyCode : ' + evtParam.key + '\n' + document.getElementById('logs').value;
      }
    },
    onLinkClick: function (evtParam) {
      // 시트 내에서 Link타입을 클릭시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
       + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onLongClick: function (evtParam) {
      // 셀을 오래 클릭하는 경우 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : '') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onMouseDown: function (evtParam) {
      // 시트 마우스 다운시 발생합니다.
      if (document.getElementById('showMOSevt').checked && evtParam.row) {
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
         + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
      }
    },
    onMouseMove: function (evtParam) {
      // if(document.getElementById("showMOSevt").checked){
      //   document.getElementById("logs").value =
      //   (samplePageObj.externalFunction.count())+"\t 이벤트 명 : "+evtParam.eventName+
      //   "\t\t\t발생 위치 : "+(evtParam.row.HasIndex?evtParam.row.HasIndex+" 행,":evtParam.row.id+" 행,")+  (evtParam.col?evtParam.col+" 열\n":"\n") + document.getElementById("logs").value;
      // }
    },
    onMouseOver: function (evtParam) {
      // 마우스 커서가 셀에서 다른 셀 위로 이동해 갈때 발생합니다.
      if (document.getElementById('showMOSevt').checked && evtParam.row) {
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t발생 위치 : ' + (evtParam.row ? (evtParam.row.HasIndex ? evtParam.row.HasIndex : evtParam.row.id) + ' 행,' : '없음 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '없음 열\n') + document.getElementById('logs').value;
      }
    },
    onMouseUp: function (evtParam) {
      if (document.getElementById('showMOSevt').checked && evtParam.row) {
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + '행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
      }
    },
    onReadCanEditDate: function (evtParam) {
      // 달력이 표시될때 발생합니다.(특정일자의 선택 가능여부를 변경가능)
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t달력 날짜 : ' + IBSheet.dateToString(evtParam.date, 'yyyy-MM-dd') + '\n' + document.getElementById('logs').value;
    },
    onReadDate: function (evtParam) {
      // 달력이 표시될때 발생합니다.(특정일자의 모양 변경 가능)
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t달력 날짜 : ' + IBSheet.dateToString(evtParam.date, 'yyyy-MM-dd') + '\n' + document.getElementById('logs').value;

      return evtParam.text;
    },

    onReadDefaults: function (evtParam) {
      // Defaults가 설정된 컬럼에서 리스트를 펼칠때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\tDefaults값 : ' + evtParam.defaults + '\n' + document.getElementById('logs').value;
    },
    // onReadEnumKeys:function(evtParam){
    //   //Enum타입의 컬럼에서 리스트를 펼칠때 발생합니다.
    //   document.getElementById("logs").value =
    //   (samplePageObj.externalFunction.count())+"\t 이벤트 명 : "+evtParam.eventName+
    //   "\t\t\tEnum key값 : "+evtParam.enumkeys+"\n" + document.getElementById("logs").value;
    // },
    // onReadEnum:function(evtParam){
    //   //Enum타입의 컬럼에서 리스트를 펼칠때 발생합니다.
    //   document.getElementById("logs").value =
    //   (samplePageObj.externalFunction.count())+"\t 이벤트 명 : "+evtParam.eventName+
    //   "\t\t\tEnum 값 : "+evtParam.enum+"\n" + document.getElementById("logs").value;

    // },
    onReadFilteringValue: function (evtParam) {
      // 필터링이 이루어 질때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t필터되는 값 : ' + evtParam.val + '\n' + document.getElementById('logs').value;
    },
    onReadMenu: function (evtParam) {
      // 메뉴가 펼쳐질때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    // onReadSuggest:function(evtParam){},
    onRenderFinish: function (evtParam) {
      // 렌더링이 이루어 질때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
       + '\n' + document.getElementById('logs').value;
    },
    onRenderFirstFinish: function (evtParam) {
      // 시트가 최초 생성되어 렌더링 되었을때 1회만 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\n' + document.getElementById('logs').value;
    },
    // onRenderPageFinish:function(evtParam){
    //   //페이지 단위 렌더링 종료시 발생합니다.
    //   document.getElementById("logs").value =
    //   (samplePageObj.externalFunction.count())+"\t 이벤트 명 : "+evtParam.eventName+
    //   "\t\t\t페이지 이름: "+(evtParam.row?evtParam.row.Name+" 행\n":"\n") + document.getElementById("logs").value;
    // },
    // onRenderPageStart:function(evtParam){
    //   //페이지 단위 렌더링 시작시점에서  발생합니다.
    //   document.getElementById("logs").value =
    //   (samplePageObj.externalFunction.count())+"\t 이벤트 명 : "+evtParam.eventName+
    //   "\t\t\t페이지 이름: "+(evtParam.row?evtParam.row.Name+" 행\n":"\n") + document.getElementById("logs").value;
    // },
    onRenderStart: function (evtParam) {
      // 렌더링 종료시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\n' + document.getElementById('logs').value;
    },
    onResultMask: function (evtParam) {

    },
    onRightClick: function (evtParam) {
      // 마우스 오른쪽 클릭시 발생합니다.
      if (evtParam.row) {
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
      }
    },
    onRightLongClick: function (evtParam) {
      // 마우스 오른쪽 클릭시 발생합니다.
      if (evtParam.row) {
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
      }
    },
    onRowAdd: function (evtParam) {
      // 행이 추가되고 렌더링 전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t\t행 객체 id : ' + evtParam.row.id + '\n' + document.getElementById('logs').value;
    },
    onRowFilter: function (evtParam) {
      // 필터링시 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
       + '\t\t\t\t행 Index : ' + evtParam.row.HasIndex + ' 보임여부 : ' + evtParam.show + '\n' + document.getElementById('logs').value;
    },
    // onRowLoad: function (evtParam) {
    //   // 데이터 로드시 행단위로 발생합니다.
    //   document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
    //    + '\t\t\t\t행 객체 id : ' + evtParam.row.id + '\n' + document.getElementById('logs').value;
    // },
    onSave: function (evtParam) {
      // 저장작업 처리 전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
       + '\n' + document.getElementById('logs').value;
    },
    onScroll: function (evtParam) {
      // 스크롤을 움직일때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
       + '\t\t\t\t가로스크롤 : ' + evtParam.hpos + ' 세로스크롤 : ' + evtParam.vpos + '\n' + document.getElementById('logs').value;
    },

    onSearchFinish: function (evtParam) {
      // 데이터 로딩 후 렌터링 완료시 발생
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName + '\n' + document.getElementById('logs').value;
    },

    onSelectMenu: function (evtParam) {
      // 컨택스트 메뉴 선택시 발생합니다
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t\t선택 값 : ' + evtParam.result + '\n' + document.getElementById('logs').value;
    },

    onShowCol: function (evtParam) {
      // 컬럼이 보여지거나 감춰질때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
       + '\t\t\t\t발생위치 : ' + evtParam.col + ' 열\t감춤여부 : ' + evtParam.hide + '\n' + document.getElementById('logs').value;
    },
    // onShowEditEnum:function(evtParam){

    // },
    onShowEdit: function (evtParam) {
      // 셀편집 시작직전에 발생하는 이벤트 입니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    // onShowEnumMenu:function(evtParam){

    // },
    onShowHint: function (evtParam) {
      if (document.getElementById('showMOSevt').checked) {
        // 힌트가 표시될때 발생합니다.
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
      }
    },
    onShowMenu: function (evtParam) {
      // 메뉴가 화면에 보여질 때 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onShowTip: function (evtParam) {
      if (document.getElementById('showMOSevt').checked) {
        // 팁(풍선도움말)이 표시될때 발생합니다.
        document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
        + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
      }
    },
    onStartDrag: function (evtParam) {
      // 행이 드래그 되기 직전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    onStartEdit: function (evtParam) {
      // 셀에대한 편집이 시작되기 직전에 발생합니다.
      document.getElementById('logs').value = (samplePageObj.externalFunction.count()) + '\t 이벤트 명 : ' + evtParam.eventName
      + '\t\t\t발생 위치 : ' + (evtParam.row.HasIndex ? evtParam.row.HasIndex + ' 행,' : evtParam.row.id + ' 행,') + (evtParam.col ? evtParam.col + ' 열\n' : '\n') + document.getElementById('logs').value;
    },
    // onSuggest:function(evtParam){

    // },
  },

  // data
  data: [
    {
      FROM_DATE: '2001-11-06',
      DEPT_NAME: 'Development',
      SALARY: 78549,
      HIRE_DATE: '1988-04-26',
      TO_DATE: '1999-01-01',
      BIRTH_DATE: '1957-10-23',
      EMP_NO: 296234,
      GENDER: 'F',
      RN: 1,
      LAST_NAME: 'Hopewell',
      FIRST_NAME: 'Stafford',
      DEPT_NO: 'd005',
      POSITION: '과장'
    },
    {
      FROM_DATE: '1996-12-28',
      DEPT_NAME: 'Finance',
      SALARY: 41338,
      HIRE_DATE: '1987-06-19',
      TO_DATE: '1997-12-28',
      BIRTH_DATE: '1955-09-03',
      EMP_NO: 296235,
      GENDER: 'F',
      RN: 2,
      LAST_NAME: 'Vidal',
      FIRST_NAME: 'Debaprosad',
      DEPT_NO: 'd002',
      HOMEPAGE: '|http://blog.naver.com/blogpeople|블로그|_blank',
      POSITION: '과장'
    },
    {
      FROM_DATE: '1987-07-04',
      DEPT_NAME: 'Development',
      SALARY: 52503,
      HIRE_DATE: '1986-07-04',
      TO_DATE: '1988-07-03',
      BIRTH_DATE: '1954-03-14',
      EMP_NO: 296236,
      GENDER: 'M',
      RN: 9,
      LAST_NAME: 'Veevers',
      FIRST_NAME: 'Susumu',
      DEPT_NO: 'd005',
      POSITION: '부장'
    },
    {
      FROM_DATE: '1989-04-20',
      DEPT_NAME: 'Production',
      SALARY: 41064,
      HIRE_DATE: '1986-08-30',
      TO_DATE: '1990-04-20',
      BIRTH_DATE: '1960-07-02',
      EMP_NO: 296237,
      GENDER: 'M',
      RN: 27,
      LAST_NAME: 'Falby',
      FIRST_NAME: 'Basant',
      DEPT_NO: 'd004',
      POSITION: '차장'
    },
    {
      FROM_DATE: '1988-04-24',
      DEPT_NAME: 'Development',
      SALARY: 40866,
      HIRE_DATE: '1987-04-25',
      TO_DATE: '1989-04-24',
      BIRTH_DATE: '1958-10-13',
      EMP_NO: 296238,
      GENDER: 'F',
      RN: 56,
      LAST_NAME: 'Peak',
      FIRST_NAME: 'Marke',
      DEPT_NO: 'd005',
      POSITION: '차장'
    },
    {
      FROM_DATE: '1993-07-13',
      DEPT_NAME: 'Production',
      SALARY: 89501,
      HIRE_DATE: '1986-07-15',
      TO_DATE: '1994-07-13',
      BIRTH_DATE: '1964-07-24',
      EMP_NO: 296239,
      GENDER: 'F',
      RN: 78,
      LAST_NAME: 'Eldridge',
      FIRST_NAME: 'Zito',
      DEPT_NO: 'd004',
      POSITION: '과장'
    },
    {
      FROM_DATE: '1999-09-08',
      DEPT_NAME: 'Development',
      SALARY: 40772,
      HIRE_DATE: '1987-05-08',
      TO_DATE: '2000-07-16',
      BIRTH_DATE: '1955-05-10',
      EMP_NO: 296240,
      GENDER: 'F',
      RN: 89,
      LAST_NAME: 'Ranka',
      FIRST_NAME: 'Brewster',
      DEPT_NO: 'd005',
      POSITION: '대리'
    },
    {
      FROM_DATE: '1999-01-26',
      DEPT_NAME: 'Finance',
      SALARY: 63955,
      HIRE_DATE: '1996-01-27',
      TO_DATE: '2000-01-26',
      BIRTH_DATE: '1952-06-01',
      EMP_NO: 296241,
      GENDER: 'F',
      RN: 93,
      LAST_NAME: 'Remmele',
      FIRST_NAME: 'Mihalis',
      DEPT_NO: 'd002',
      POSITION: '대리'
    },
    {
      FROM_DATE: '1991-06-30',
      DEPT_NAME: 'Sales',
      SALARY: 60728,
      HIRE_DATE: '1990-06-30',
      TO_DATE: '1992-06-29',
      BIRTH_DATE: '1959-10-21',
      EMP_NO: 296243,
      GENDER: 'F',
      RN: 102,
      LAST_NAME: 'Casley',
      FIRST_NAME: 'Arne',
      DEPT_NO: 'd007',
      POSITION: '사원'
    },
    {
      FROM_DATE: '1994-01-07',
      DEPT_NAME: 'Development',
      SALARY: 43759,
      HIRE_DATE: '1993-01-07',
      TO_DATE: '1995-01-07',
      BIRTH_DATE: '1961-10-10',
      EMP_NO: 296244,
      GENDER: 'M',
      RN: 115,
      LAST_NAME: 'Lampe',
      FIRST_NAME: 'Jiong',
      DEPT_NO: 'd005',
      POSITION: '사원'
    },
    {
      FROM_DATE: '1998-05-19',
      DEPT_NAME: 'Sales',
      SALARY: 51095,
      HIRE_DATE: '1992-08-12',
      TO_DATE: '1999-05-19',
      BIRTH_DATE: '1955-11-18',
      EMP_NO: 296245,
      GENDER: 'M',
      RN: 122,
      LAST_NAME: 'Murtha',
      FIRST_NAME: 'Christophe',
      DEPT_NO: 'd007',
      POSITION: '과장'
    },
    {
      FROM_DATE: '1986-12-28',
      DEPT_NAME: 'Customer Service',
      SALARY: 70702,
      HIRE_DATE: '1986-12-28',
      TO_DATE: '1987-12-28',
      BIRTH_DATE: '1958-05-07',
      EMP_NO: 296246,
      GENDER: 'M',
      RN: 125,
      LAST_NAME: 'Portugali',
      FIRST_NAME: 'Ekawit',
      DEPT_NO: 'd009',
      POSITION: '대리'
    },
    {
      FROM_DATE: '1998-08-17',
      DEPT_NAME: 'Production',
      SALARY: 60599,
      HIRE_DATE: '1989-08-19',
      TO_DATE: '1999-08-17',
      BIRTH_DATE: '1964-01-05',
      EMP_NO: 296247,
      GENDER: 'F',
      RN: 165,
      LAST_NAME: 'Chaudhury',
      FIRST_NAME: 'Vivian',
      DEPT_NO: 'd004',
      POSITION: '단기계약'
    },
    {
      FROM_DATE: '1990-11-11',
      DEPT_NAME: 'Development',
      SALARY: 49072,
      HIRE_DATE: '1987-11-12',
      TO_DATE: '1991-11-11',
      BIRTH_DATE: '1959-10-15',
      EMP_NO: 296248,
      GENDER: 'M',
      RN: 172,
      LAST_NAME: 'Dalphin',
      FIRST_NAME: 'Jamaludin',
      DEPT_NO: 'd005',
      POSITION: '차장'
    },
    {
      FROM_DATE: '2000-07-07',
      DEPT_NAME: 'Production',
      SALARY: 65393,
      HIRE_DATE: '1985-07-24',
      TO_DATE: '2001-07-07',
      BIRTH_DATE: '1962-02-24',
      EMP_NO: 296249,
      GENDER: 'M',
      RN: 191,
      LAST_NAME: 'Linnainmaa',
      FIRST_NAME: 'Franziska',
      DEPT_NO: 'd004',
      POSITION: '부장'
    },
    {
      FROM_DATE: '1996-09-19',
      DEPT_NAME: 'Sales',
      SALARY: 120828,
      HIRE_DATE: '1989-09-21',
      TO_DATE: '1997-09-19',
      BIRTH_DATE: '1961-04-30',
      EMP_NO: 296250,
      GENDER: 'M',
      RN: 201,
      LAST_NAME: 'Papsdorf',
      FIRST_NAME: 'Krisda',
      DEPT_NO: 'd007',
      POSITION: '차장'
    },
    {
      FROM_DATE: '1999-06-26',
      DEPT_NAME: 'Marketing',
      SALARY: 88859,
      HIRE_DATE: '1986-06-29',
      TO_DATE: '2000-06-25',
      BIRTH_DATE: '1956-12-21',
      EMP_NO: 296602,
      GENDER: 'M',
      RN: 212,
      LAST_NAME: 'Broder',
      FIRST_NAME: 'Boriana',
      DEPT_NO: 'd001',
      POSITION: '이사'
    },
    {
      FROM_DATE: '1999-11-19',
      DEPT_NAME: 'Development',
      SALARY: 59155,
      HIRE_DATE: '1991-07-16',
      TO_DATE: '2000-11-18',
      BIRTH_DATE: '1954-05-15',
      EMP_NO: 296603,
      GENDER: 'F',
      RN: 217,
      LAST_NAME: 'Worfolk',
      FIRST_NAME: 'Zissis',
      DEPT_NO: 'd005',
      POSITION: '부장'
    },
    {
      FROM_DATE: '1999-12-02',
      DEPT_NAME: 'Sales',
      SALARY: 73985,
      HIRE_DATE: '1987-07-13',
      TO_DATE: '2000-12-01',
      BIRTH_DATE: '1959-05-26',
      EMP_NO: 296604,
      GENDER: 'F',
      RN: 227,
      LAST_NAME: 'Valiente',
      FIRST_NAME: 'Vishv',
      DEPT_NO: 'd007',
      POSITION: '전무'
    },
    {
      FROM_DATE: '1987-04-26',
      DEPT_NAME: 'Marketing',
      SALARY: 64699,
      HIRE_DATE: '1985-04-04',
      TO_DATE: '1988-04-25',
      BIRTH_DATE: '1953-07-05',
      EMP_NO: 296605,
      GENDER: 'M',
      RN: 231,
      LAST_NAME: 'Tischendorf',
      FIRST_NAME: 'Karlis',
      DEPT_NO: 'd001',
      POSITION: '과장'
    },
    {
      FROM_DATE: '1988-08-26',
      DEPT_NAME: 'Finance',
      SALARY: 87888,
      HIRE_DATE: '1986-08-27',
      TO_DATE: '1989-08-26',
      BIRTH_DATE: '1963-03-15',
      EMP_NO: 296606,
      GENDER: 'M',
      RN: 249,
      LAST_NAME: 'Pauthner',
      FIRST_NAME: 'Baruch',
      DEPT_NO: 'd002',
      POSITION: '상무'
    },
    {
      FROM_DATE: '1995-06-11',
      DEPT_NAME: 'Sales',
      SALARY: 77513,
      HIRE_DATE: '1991-07-15',
      TO_DATE: '1996-06-10',
      BIRTH_DATE: '1954-09-17',
      EMP_NO: 296607,
      GENDER: 'M',
      RN: 258,
      LAST_NAME: 'Luef',
      FIRST_NAME: 'Persi',
      DEPT_NO: 'd007',
      POSITION: '단기계약'
    },
    {
      FROM_DATE: '1990-03-13',
      DEPT_NAME: 'Sales',
      SALARY: 64390,
      HIRE_DATE: '1990-03-13',
      TO_DATE: '1991-03-13',
      BIRTH_DATE: '1952-06-18',
      EMP_NO: 296609,
      GENDER: 'M',
      RN: 267,
      LAST_NAME: 'Litvinov',
      FIRST_NAME: 'Jayson',
      DEPT_NO: 'd007',
      POSITION: '과장'
    },
    {
      FROM_DATE: '1990-07-05',
      DEPT_NAME: 'Development',
      SALARY: 40000,
      HIRE_DATE: '1990-07-05',
      TO_DATE: '1990-07-12',
      BIRTH_DATE: '1956-10-26',
      EMP_NO: 296608,
      GENDER: 'F',
      RN: 265,
      LAST_NAME: 'Ravishankar',
      FIRST_NAME: 'Tomokazu',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1997-11-11',
      DEPT_NAME: 'Quality Management',
      SALARY: 41527,
      HIRE_DATE: '1995-11-12',
      TO_DATE: '1998-11-11',
      BIRTH_DATE: '1964-08-22',
      EMP_NO: 298934,
      GENDER: 'F',
      RN: 270,
      LAST_NAME: 'Varker',
      FIRST_NAME: 'Wanqing',
      DEPT_NO: 'd006'
    },
    {
      FROM_DATE: '1992-09-24',
      DEPT_NAME: 'Human Resources',
      SALARY: 42562,
      HIRE_DATE: '1988-07-17',
      TO_DATE: '1993-09-24',
      BIRTH_DATE: '1955-03-30',
      EMP_NO: 298935,
      GENDER: 'F',
      RN: 276,
      LAST_NAME: 'Veccia',
      FIRST_NAME: 'Sungwon',
      DEPT_NO: 'd003'
    },
    {
      FROM_DATE: '2000-07-16',
      DEPT_NAME: 'Customer Service',
      SALARY: 76252,
      HIRE_DATE: '1985-07-20',
      TO_DATE: '2001-07-16',
      BIRTH_DATE: '1959-12-18',
      EMP_NO: 298936,
      GENDER: 'F',
      RN: 295,
      LAST_NAME: 'Muntz',
      FIRST_NAME: 'Kshitij',
      DEPT_NO: 'd009'
    },
    {
      FROM_DATE: '1998-09-27',
      DEPT_NAME: 'Sales',
      SALARY: 58114,
      HIRE_DATE: '1987-04-27',
      TO_DATE: '1999-09-27',
      BIRTH_DATE: '1963-05-20',
      EMP_NO: 298937,
      GENDER: 'F',
      RN: 299,
      LAST_NAME: 'Birke',
      FIRST_NAME: 'Sorina',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1994-02-05',
      DEPT_NAME: 'Quality Management',
      SALARY: 53823,
      HIRE_DATE: '1994-02-05',
      TO_DATE: '1995-02-05',
      BIRTH_DATE: '1964-10-30',
      EMP_NO: 298938,
      GENDER: 'M',
      RN: 304,
      LAST_NAME: 'Demos',
      FIRST_NAME: 'Yagil',
      DEPT_NO: 'd006'
    },
    {
      FROM_DATE: '1997-10-21',
      DEPT_NAME: 'Customer Service',
      SALARY: 78595,
      HIRE_DATE: '1986-10-24',
      TO_DATE: '1998-10-21',
      BIRTH_DATE: '1952-10-28',
      EMP_NO: 298939,
      GENDER: 'F',
      RN: 332,
      LAST_NAME: 'Thorensen',
      FIRST_NAME: 'Alenka',
      DEPT_NO: 'd009'
    },
    {
      FROM_DATE: '1994-04-28',
      DEPT_NAME: 'Sales',
      SALARY: 63945,
      HIRE_DATE: '1991-06-27',
      TO_DATE: '1995-04-28',
      BIRTH_DATE: '1959-08-07',
      EMP_NO: 298940,
      GENDER: 'M',
      RN: 338,
      LAST_NAME: 'Covnot',
      FIRST_NAME: 'Geoffry',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '2000-07-26',
      DEPT_NAME: 'Customer Service',
      SALARY: 51260,
      HIRE_DATE: '1990-12-24',
      TO_DATE: '2001-07-26',
      BIRTH_DATE: '1954-11-15',
      EMP_NO: 298941,
      GENDER: 'M',
      RN: 349,
      LAST_NAME: 'Prampolini',
      FIRST_NAME: 'Emran',
      DEPT_NO: 'd009'
    },
    {
      FROM_DATE: '1992-08-29',
      DEPT_NAME: 'Research',
      SALARY: 50629,
      HIRE_DATE: '1989-08-30',
      TO_DATE: '1993-08-29',
      BIRTH_DATE: '1952-12-25',
      EMP_NO: 298943,
      GENDER: 'M',
      RN: 356,
      LAST_NAME: 'Miyakawa',
      FIRST_NAME: 'Golgen',
      DEPT_NO: 'd008'
    },
    {
      FROM_DATE: '1996-06-03',
      DEPT_NAME: 'Research',
      SALARY: 54843,
      HIRE_DATE: '1996-01-26',
      TO_DATE: '1997-01-13',
      BIRTH_DATE: '1952-03-12',
      EMP_NO: 298942,
      GENDER: 'M',
      RN: 352,
      LAST_NAME: 'Gniady',
      FIRST_NAME: 'Sivanarayana',
      DEPT_NO: 'd008'
    },
    {
      FROM_DATE: '2001-06-04',
      DEPT_NAME: 'Development',
      SALARY: 57325,
      HIRE_DATE: '1997-03-05',
      TO_DATE: '2002-06-04',
      BIRTH_DATE: '1958-10-12',
      EMP_NO: 298944,
      GENDER: 'M',
      RN: 368,
      LAST_NAME: 'Leslie',
      FIRST_NAME: 'Syozo',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1998-08-02',
      DEPT_NAME: 'Sales',
      SALARY: 67576,
      HIRE_DATE: '1987-12-29',
      TO_DATE: '1999-08-02',
      BIRTH_DATE: '1956-02-27',
      EMP_NO: 298945,
      GENDER: 'M',
      RN: 375,
      LAST_NAME: 'Schahn',
      FIRST_NAME: 'Henk',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1991-07-26',
      DEPT_NAME: 'Development',
      SALARY: 40000,
      HIRE_DATE: '1991-07-26',
      TO_DATE: '1992-07-25',
      BIRTH_DATE: '1964-07-10',
      EMP_NO: 298946,
      GENDER: 'M',
      RN: 381,
      LAST_NAME: 'Gecseg',
      FIRST_NAME: 'Gift',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1994-02-10',
      DEPT_NAME: 'Development',
      SALARY: 57858,
      HIRE_DATE: '1991-02-11',
      TO_DATE: '1995-02-10',
      BIRTH_DATE: '1962-03-02',
      EMP_NO: 298947,
      GENDER: 'M',
      RN: 407,
      LAST_NAME: 'Setlzner',
      FIRST_NAME: 'Bogdan',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1998-10-22',
      DEPT_NAME: 'Production',
      SALARY: 49106,
      HIRE_DATE: '1988-04-02',
      TO_DATE: '1999-10-22',
      BIRTH_DATE: '1958-06-06',
      EMP_NO: 298948,
      GENDER: 'M',
      RN: 424,
      LAST_NAME: 'Brookman',
      FIRST_NAME: 'KayLiang',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '2000-02-21',
      DEPT_NAME: 'Quality Management',
      SALARY: 47630,
      HIRE_DATE: '1991-02-23',
      TO_DATE: '2001-02-20',
      BIRTH_DATE: '1964-09-29',
      EMP_NO: 298949,
      GENDER: 'M',
      RN: 437,
      LAST_NAME: 'Escriba',
      FIRST_NAME: 'Xuejia',
      DEPT_NO: 'd006'
    },
    {
      FROM_DATE: '1989-09-11',
      DEPT_NAME: 'Development',
      SALARY: 57803,
      HIRE_DATE: '1986-09-12',
      TO_DATE: '1990-09-11',
      BIRTH_DATE: '1955-02-19',
      EMP_NO: 298950,
      GENDER: 'F',
      RN: 443,
      LAST_NAME: 'Armand',
      FIRST_NAME: 'Mabry',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1986-07-14',
      DEPT_NAME: 'Development',
      SALARY: 42933,
      HIRE_DATE: '1985-07-14',
      TO_DATE: '1987-07-14',
      BIRTH_DATE: '1956-11-08',
      EMP_NO: 298951,
      GENDER: 'M',
      RN: 457,
      LAST_NAME: 'Pavlopoulou',
      FIRST_NAME: 'Marjo',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1997-10-02',
      DEPT_NAME: 'Sales',
      SALARY: 109069,
      HIRE_DATE: '1990-02-16',
      TO_DATE: '1998-10-02',
      BIRTH_DATE: '1955-08-02',
      EMP_NO: 296203,
      GENDER: 'M',
      RN: 466,
      LAST_NAME: 'Maquelin',
      FIRST_NAME: 'Douadi',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1991-11-09',
      DEPT_NAME: 'Production',
      SALARY: 50359,
      HIRE_DATE: '1988-04-26',
      TO_DATE: '1992-11-08',
      BIRTH_DATE: '1959-09-12',
      EMP_NO: 296204,
      GENDER: 'M',
      RN: 472,
      LAST_NAME: 'Demir',
      FIRST_NAME: 'Kazuhiro',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1998-05-18',
      DEPT_NAME: 'Development',
      SALARY: 54516,
      HIRE_DATE: '1994-05-19',
      TO_DATE: '1999-05-18',
      BIRTH_DATE: '1964-04-05',
      EMP_NO: 296205,
      GENDER: 'F',
      RN: 487,
      LAST_NAME: 'Unno',
      FIRST_NAME: 'Sanjay',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1999-05-20',
      DEPT_NAME: 'Development',
      SALARY: 67581,
      HIRE_DATE: '1992-05-21',
      TO_DATE: '2000-05-19',
      BIRTH_DATE: '1957-11-08',
      EMP_NO: 296206,
      GENDER: 'F',
      RN: 499,
      LAST_NAME: 'Eickenmeyer',
      FIRST_NAME: 'Toshimo',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '2000-03-28',
      DEPT_NAME: 'Sales',
      SALARY: 73078,
      HIRE_DATE: '1995-03-30',
      TO_DATE: '2001-03-28',
      BIRTH_DATE: '1960-11-17',
      EMP_NO: 296207,
      GENDER: 'F',
      RN: 508,
      LAST_NAME: 'Cincotta',
      FIRST_NAME: 'Girolamo',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '2001-01-25',
      DEPT_NAME: 'Development',
      SALARY: 49994,
      HIRE_DATE: '1993-08-07',
      TO_DATE: '2002-01-25',
      BIRTH_DATE: '1957-03-06',
      EMP_NO: 296208,
      GENDER: 'M',
      RN: 512,
      LAST_NAME: 'Munawer',
      FIRST_NAME: 'Kauko',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1991-07-19',
      DEPT_NAME: 'Production',
      SALARY: 40013,
      HIRE_DATE: '1990-07-19',
      TO_DATE: '1992-07-18',
      BIRTH_DATE: '1957-07-19',
      EMP_NO: 296209,
      GENDER: 'F',
      RN: 516,
      LAST_NAME: 'Collavizza',
      FIRST_NAME: 'Jeanna',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1992-03-12',
      DEPT_NAME: 'Sales',
      SALARY: 70168,
      HIRE_DATE: '1990-03-13',
      TO_DATE: '1993-03-12',
      BIRTH_DATE: '1952-06-18',
      EMP_NO: 296609,
      GENDER: 'M',
      RN: 533,
      LAST_NAME: 'Litvinov',
      FIRST_NAME: 'Jayson',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1992-10-05',
      DEPT_NAME: 'Production',
      SALARY: 45375,
      HIRE_DATE: '1990-10-06',
      TO_DATE: '1993-10-05',
      BIRTH_DATE: '1965-01-25',
      EMP_NO: 296610,
      GENDER: 'F',
      RN: 556,
      LAST_NAME: 'Berztiss',
      FIRST_NAME: 'Pranav',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1998-10-23',
      DEPT_NAME: 'Customer Service',
      SALARY: 40000,
      HIRE_DATE: '1998-03-14',
      TO_DATE: '1999-10-23',
      BIRTH_DATE: '1960-06-24',
      EMP_NO: 296612,
      GENDER: 'M',
      RN: 566,
      LAST_NAME: 'Gomatam',
      FIRST_NAME: 'Christ',
      DEPT_NO: 'd009'
    },
    {
      FROM_DATE: '1998-01-15',
      DEPT_NAME: 'Development',
      SALARY: 47294,
      HIRE_DATE: '1987-07-19',
      TO_DATE: '1999-01-15',
      BIRTH_DATE: '1963-09-03',
      EMP_NO: 296613,
      GENDER: 'M',
      RN: 573,
      LAST_NAME: 'Swen',
      FIRST_NAME: 'Hyuncheol',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1993-08-15',
      DEPT_NAME: 'Production',
      SALARY: 44324,
      HIRE_DATE: '1990-08-16',
      TO_DATE: '1994-08-15',
      BIRTH_DATE: '1961-11-27',
      EMP_NO: 296614,
      GENDER: 'M',
      RN: 581,
      LAST_NAME: 'Piveteau',
      FIRST_NAME: 'Spyrose',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1998-08-14',
      DEPT_NAME: 'Production',
      SALARY: 48287,
      HIRE_DATE: '1990-08-16',
      TO_DATE: '1999-08-14',
      BIRTH_DATE: '1961-11-27',
      EMP_NO: 296614,
      GENDER: 'M',
      RN: 586,
      LAST_NAME: 'Piveteau',
      FIRST_NAME: 'Spyrose',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1991-05-07',
      DEPT_NAME: 'Development',
      SALARY: 62092,
      HIRE_DATE: '1988-05-07',
      TO_DATE: '1992-05-06',
      BIRTH_DATE: '1954-01-10',
      EMP_NO: 296615,
      GENDER: 'F',
      RN: 593,
      LAST_NAME: 'Leijenhorst',
      FIRST_NAME: 'Nagui',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1995-05-15',
      DEPT_NAME: 'Sales',
      SALARY: 103868,
      HIRE_DATE: '1993-05-15',
      TO_DATE: '1996-05-14',
      BIRTH_DATE: '1952-08-27',
      EMP_NO: 296616,
      GENDER: 'F',
      RN: 607,
      LAST_NAME: 'Danner',
      FIRST_NAME: 'Heon',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1994-06-15',
      DEPT_NAME: 'Sales',
      SALARY: 52685,
      HIRE_DATE: '1992-06-15',
      TO_DATE: '1995-06-15',
      BIRTH_DATE: '1955-05-25',
      EMP_NO: 296617,
      GENDER: 'M',
      RN: 617,
      LAST_NAME: 'Orlowska',
      FIRST_NAME: 'Somnath',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1992-09-11',
      DEPT_NAME: 'Sales',
      SALARY: 71108,
      HIRE_DATE: '1991-09-12',
      TO_DATE: '1993-09-11',
      BIRTH_DATE: '1959-07-22',
      EMP_NO: 296618,
      GENDER: 'M',
      RN: 629,
      LAST_NAME: 'Leaver',
      FIRST_NAME: 'Tokuyasu',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1999-01-11',
      DEPT_NAME: 'Development',
      SALARY: 53670,
      HIRE_DATE: '1985-05-06',
      TO_DATE: '2000-01-11',
      BIRTH_DATE: '1952-06-29',
      EMP_NO: 296619,
      GENDER: 'F',
      RN: 650,
      LAST_NAME: 'Brickell',
      FIRST_NAME: 'Frederique',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1990-01-28',
      DEPT_NAME: 'Production',
      SALARY: 57483,
      HIRE_DATE: '1987-01-29',
      TO_DATE: '1991-01-28',
      BIRTH_DATE: '1960-10-28',
      EMP_NO: 296620,
      GENDER: 'M',
      RN: 657,
      LAST_NAME: 'Madeira',
      FIRST_NAME: 'Ult',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1988-07-04',
      DEPT_NAME: 'Production',
      SALARY: 43314,
      HIRE_DATE: '1986-07-05',
      TO_DATE: '1989-04-27',
      BIRTH_DATE: '1965-01-02',
      EMP_NO: 296621,
      GENDER: 'M',
      RN: 672,
      LAST_NAME: 'Plump',
      FIRST_NAME: 'Bokyung',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '2001-09-07',
      DEPT_NAME: 'Development',
      SALARY: 43522,
      HIRE_DATE: '1996-03-17',
      TO_DATE: '1999-01-01',
      BIRTH_DATE: '1954-10-29',
      EMP_NO: 296622,
      GENDER: 'M',
      RN: 675,
      LAST_NAME: 'Dengi',
      FIRST_NAME: 'Serenella',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1993-08-30',
      DEPT_NAME: 'Sales',
      SALARY: 105952,
      HIRE_DATE: '1990-08-31',
      TO_DATE: '1994-08-30',
      BIRTH_DATE: '1952-08-10',
      EMP_NO: 296623,
      GENDER: 'M',
      RN: 679,
      LAST_NAME: 'Herbst',
      FIRST_NAME: 'Zeljko',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1996-01-06',
      DEPT_NAME: 'Production',
      SALARY: 43459,
      HIRE_DATE: '1994-01-06',
      TO_DATE: '1997-01-05',
      BIRTH_DATE: '1963-01-24',
      EMP_NO: 296624,
      GENDER: 'F',
      RN: 690,
      LAST_NAME: 'Yurek',
      FIRST_NAME: 'Guenter',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1987-05-10',
      DEPT_NAME: 'Sales',
      SALARY: 57939,
      HIRE_DATE: '1985-05-10',
      TO_DATE: '1988-05-09',
      BIRTH_DATE: '1954-07-07',
      EMP_NO: 296625,
      GENDER: 'M',
      RN: 699,
      LAST_NAME: 'Erdi',
      FIRST_NAME: 'Goa',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1995-04-06',
      DEPT_NAME: 'Development',
      SALARY: 43360,
      HIRE_DATE: '1992-12-07',
      TO_DATE: '1996-04-04',
      BIRTH_DATE: '1962-07-08',
      EMP_NO: 296626,
      GENDER: 'F',
      RN: 716,
      LAST_NAME: 'Norsworthy',
      FIRST_NAME: 'Huan',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1985-04-10',
      DEPT_NAME: 'Customer Service',
      SALARY: 84730,
      HIRE_DATE: '1985-04-10',
      TO_DATE: '1986-04-10',
      BIRTH_DATE: '1960-10-17',
      EMP_NO: 296627,
      GENDER: 'F',
      RN: 725,
      LAST_NAME: 'Demri',
      FIRST_NAME: 'Florina',
      DEPT_NO: 'd009'
    },
    {
      FROM_DATE: '1995-01-21',
      DEPT_NAME: 'Development',
      SALARY: 44554,
      HIRE_DATE: '1993-01-21',
      TO_DATE: '1996-01-21',
      BIRTH_DATE: '1961-11-05',
      EMP_NO: 297004,
      GENDER: 'M',
      RN: 731,
      LAST_NAME: 'Milicia',
      FIRST_NAME: 'Mingdong',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1998-09-19',
      DEPT_NAME: 'Research',
      SALARY: 71684,
      HIRE_DATE: '1987-08-02',
      TO_DATE: '1999-09-19',
      BIRTH_DATE: '1952-07-27',
      EMP_NO: 297006,
      GENDER: 'M',
      RN: 755,
      LAST_NAME: 'Etalle',
      FIRST_NAME: 'Weiru',
      DEPT_NO: 'd008'
    },
    {
      FROM_DATE: '1996-04-24',
      DEPT_NAME: 'Customer Service',
      SALARY: 53359,
      HIRE_DATE: '1989-04-26',
      TO_DATE: '1997-04-24',
      BIRTH_DATE: '1962-09-19',
      EMP_NO: 297007,
      GENDER: 'M',
      RN: 774,
      LAST_NAME: 'Merkl',
      FIRST_NAME: 'Udo',
      DEPT_NO: 'd009'
    },
    {
      FROM_DATE: '1993-12-19',
      DEPT_NAME: 'Production',
      SALARY: 51454,
      HIRE_DATE: '1988-12-20',
      TO_DATE: '1994-12-19',
      BIRTH_DATE: '1962-07-26',
      EMP_NO: 297009,
      GENDER: 'M',
      RN: 795,
      LAST_NAME: 'Ginneken',
      FIRST_NAME: 'Guadalupe',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1997-01-01',
      DEPT_NAME: 'Production',
      SALARY: 61295,
      HIRE_DATE: '1990-01-03',
      TO_DATE: '1998-01-01',
      BIRTH_DATE: '1952-10-14',
      EMP_NO: 297011,
      GENDER: 'F',
      RN: 820,
      LAST_NAME: 'Riefers',
      FIRST_NAME: 'Woody',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1985-09-21',
      DEPT_NAME: 'Sales',
      SALARY: 67180,
      HIRE_DATE: '1985-09-21',
      TO_DATE: '1986-09-21',
      BIRTH_DATE: '1960-06-04',
      EMP_NO: 297013,
      GENDER: 'F',
      RN: 831,
      LAST_NAME: 'Wuwongse',
      FIRST_NAME: 'Apostol',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1999-07-20',
      DEPT_NAME: 'Production',
      SALARY: 53768,
      HIRE_DATE: '1986-06-07',
      TO_DATE: '1999-08-13',
      BIRTH_DATE: '1961-12-18',
      EMP_NO: 297014,
      GENDER: 'F',
      RN: 844,
      LAST_NAME: 'Falster',
      FIRST_NAME: 'Tadahiko',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1993-03-18',
      DEPT_NAME: 'Development',
      SALARY: 42132,
      HIRE_DATE: '1992-03-18',
      TO_DATE: '1994-03-18',
      BIRTH_DATE: '1963-04-04',
      EMP_NO: 297016,
      GENDER: 'F',
      RN: 862,
      LAST_NAME: 'Peres',
      FIRST_NAME: 'Gou',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1993-04-18',
      DEPT_NAME: 'Production',
      SALARY: 64524,
      HIRE_DATE: '1988-04-19',
      TO_DATE: '1994-04-18',
      BIRTH_DATE: '1957-11-27',
      EMP_NO: 297017,
      GENDER: 'M',
      RN: 877,
      LAST_NAME: 'Schach',
      FIRST_NAME: 'Sariel',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1990-09-02',
      DEPT_NAME: 'Production',
      SALARY: 50625,
      HIRE_DATE: '1985-05-26',
      TO_DATE: '1991-09-02',
      BIRTH_DATE: '1959-03-03',
      EMP_NO: 297018,
      GENDER: 'F',
      RN: 889,
      LAST_NAME: 'Gulak',
      FIRST_NAME: 'Haldon',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '2002-07-09',
      DEPT_NAME: 'Production',
      SALARY: 78965,
      HIRE_DATE: '1988-11-04',
      TO_DATE: '1999-01-01',
      BIRTH_DATE: '1958-02-16',
      EMP_NO: 297020,
      GENDER: 'F',
      RN: 922,
      LAST_NAME: 'Esposito',
      FIRST_NAME: 'Tsvetan',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1990-02-01',
      DEPT_NAME: 'Sales',
      SALARY: 68216,
      HIRE_DATE: '1985-02-02',
      TO_DATE: '1991-02-01',
      BIRTH_DATE: '1960-02-19',
      EMP_NO: 297022,
      GENDER: 'M',
      RN: 934,
      LAST_NAME: 'Swist',
      FIRST_NAME: 'Kousuke',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1991-08-18',
      DEPT_NAME: 'Research',
      SALARY: 43295,
      HIRE_DATE: '1989-08-18',
      TO_DATE: '1992-08-17',
      BIRTH_DATE: '1957-03-21',
      EMP_NO: 297023,
      GENDER: 'M',
      RN: 949,
      LAST_NAME: 'Lowrie',
      FIRST_NAME: 'Taisook',
      DEPT_NO: 'd008'
    },
    {
      FROM_DATE: '1991-11-20',
      DEPT_NAME: 'Human Resources',
      SALARY: 47296,
      HIRE_DATE: '1986-05-02',
      TO_DATE: '1992-11-19',
      BIRTH_DATE: '1954-11-10',
      EMP_NO: 297024,
      GENDER: 'F',
      RN: 963,
      LAST_NAME: 'Pews',
      FIRST_NAME: 'Lakshmi',
      DEPT_NO: 'd003'
    },
    {
      FROM_DATE: '1995-12-24',
      DEPT_NAME: 'Development',
      SALARY: 41487,
      HIRE_DATE: '1992-11-04',
      TO_DATE: '1996-12-23',
      BIRTH_DATE: '1959-11-11',
      EMP_NO: 297025,
      GENDER: 'F',
      RN: 975,
      LAST_NAME: 'Candan',
      FIRST_NAME: 'Masako',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1990-12-20',
      DEPT_NAME: 'Sales',
      SALARY: 72246,
      HIRE_DATE: '1987-12-21',
      TO_DATE: '1991-12-20',
      BIRTH_DATE: '1955-08-01',
      EMP_NO: 297026,
      GENDER: 'M',
      RN: 989,
      LAST_NAME: 'Schaar',
      FIRST_NAME: 'Niranjan',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '1995-10-26',
      DEPT_NAME: 'Development',
      SALARY: 47934,
      HIRE_DATE: '1993-10-26',
      TO_DATE: '1996-10-25',
      BIRTH_DATE: '1954-11-04',
      EMP_NO: 400523,
      GENDER: 'M',
      RN: 1004,
      LAST_NAME: 'Mandelberg',
      FIRST_NAME: 'Eberhardt',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1995-12-13',
      DEPT_NAME: 'Development',
      SALARY: 52607,
      HIRE_DATE: '1987-06-11',
      TO_DATE: '1996-12-12',
      BIRTH_DATE: '1956-12-18',
      EMP_NO: 400524,
      GENDER: 'F',
      RN: 1018,
      LAST_NAME: 'Mandelberg',
      FIRST_NAME: 'Morrie',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1994-05-29',
      DEPT_NAME: 'Finance',
      SALARY: 90400,
      HIRE_DATE: '1989-05-30',
      TO_DATE: '1995-05-29',
      BIRTH_DATE: '1953-06-01',
      EMP_NO: 400525,
      GENDER: 'M',
      RN: 1030,
      LAST_NAME: 'DuBourdieux',
      FIRST_NAME: 'Perry',
      DEPT_NO: 'd002'
    },
    {
      FROM_DATE: '1991-08-21',
      DEPT_NAME: 'Customer Service',
      SALARY: 44921,
      HIRE_DATE: '1989-08-21',
      TO_DATE: '1992-08-20',
      BIRTH_DATE: '1964-05-29',
      EMP_NO: 400526,
      GENDER: 'F',
      RN: 1041,
      LAST_NAME: 'Ruemmler',
      FIRST_NAME: 'Mitchel',
      DEPT_NO: 'd009'
    },
    {
      FROM_DATE: '1993-05-30',
      DEPT_NAME: 'Development',
      SALARY: 86902,
      HIRE_DATE: '1990-05-31',
      TO_DATE: '1994-05-30',
      BIRTH_DATE: '1960-11-01',
      EMP_NO: 400527,
      GENDER: 'M',
      RN: 1055,
      LAST_NAME: 'Karlin',
      FIRST_NAME: 'Izaskun',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1999-02-24',
      DEPT_NAME: 'Development',
      SALARY: 71211,
      HIRE_DATE: '1987-02-27',
      TO_DATE: '2000-02-10',
      BIRTH_DATE: '1957-10-04',
      EMP_NO: 298535,
      GENDER: 'M',
      RN: 1067,
      LAST_NAME: 'Diderrich',
      FIRST_NAME: 'Kristinn',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '2000-10-25',
      DEPT_NAME: 'Sales',
      SALARY: 70960,
      HIRE_DATE: '1986-01-22',
      TO_DATE: '2001-10-25',
      BIRTH_DATE: '1959-08-16',
      EMP_NO: 298537,
      GENDER: 'M',
      RN: 1082,
      LAST_NAME: 'Szilard',
      FIRST_NAME: 'Constantine',
      DEPT_NO: 'd007'
    },
    {
      FROM_DATE: '2002-07-15',
      DEPT_NAME: 'Production',
      SALARY: 80746,
      HIRE_DATE: '1986-01-09',
      TO_DATE: '1999-01-01',
      BIRTH_DATE: '1960-04-28',
      EMP_NO: 298538,
      GENDER: 'F',
      RN: 1087,
      LAST_NAME: 'Olano',
      FIRST_NAME: 'Rosella',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '2000-08-28',
      DEPT_NAME: 'Development',
      SALARY: 42447,
      HIRE_DATE: '1995-09-26',
      TO_DATE: '2001-08-28',
      BIRTH_DATE: '1958-05-07',
      EMP_NO: 298539,
      GENDER: 'F',
      RN: 1090,
      LAST_NAME: 'Brandsma',
      FIRST_NAME: 'Dinah',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1998-06-13',
      DEPT_NAME: 'Production',
      SALARY: 60401,
      HIRE_DATE: '1985-02-21',
      TO_DATE: '1999-06-13',
      BIRTH_DATE: '1956-01-16',
      EMP_NO: 298540,
      GENDER: 'F',
      RN: 1096,
      LAST_NAME: 'Kushnir',
      FIRST_NAME: 'Gurbir',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '1997-05-27',
      DEPT_NAME: 'Development',
      SALARY: 48189,
      HIRE_DATE: '1990-02-26',
      TO_DATE: '1997-12-22',
      BIRTH_DATE: '1964-08-20',
      EMP_NO: 298541,
      GENDER: 'M',
      RN: 1104,
      LAST_NAME: 'Syang',
      FIRST_NAME: 'Jayesh',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1999-11-06',
      DEPT_NAME: 'Human Resources',
      SALARY: 43161,
      HIRE_DATE: '1989-03-11',
      TO_DATE: '2000-11-05',
      BIRTH_DATE: '1960-06-25',
      EMP_NO: 298542,
      GENDER: 'M',
      RN: 1108,
      LAST_NAME: 'Buchter',
      FIRST_NAME: 'Minghong',
      DEPT_NO: 'd003'
    },
    {
      FROM_DATE: '1987-06-28',
      DEPT_NAME: 'Production',
      SALARY: 60310,
      HIRE_DATE: '1985-06-28',
      TO_DATE: '1988-06-27',
      BIRTH_DATE: '1957-05-18',
      EMP_NO: 298543,
      GENDER: 'F',
      RN: 1115,
      LAST_NAME: 'Schapiro',
      FIRST_NAME: 'Youpyo',
      DEPT_NO: 'd004'
    },
    {
      FROM_DATE: '2000-06-03',
      DEPT_NAME: 'Development',
      SALARY: 63395,
      HIRE_DATE: '1995-08-21',
      TO_DATE: '2001-06-03',
      BIRTH_DATE: '1955-05-01',
      EMP_NO: 298544,
      GENDER: 'F',
      RN: 1150,
      LAST_NAME: 'Haldar',
      FIRST_NAME: 'Parke',
      DEPT_NO: 'd005'
    },
    {
      FROM_DATE: '1994-12-21',
      DEPT_NAME: 'Quality Management',
      SALARY: 47514,
      HIRE_DATE: '1991-12-22',
      TO_DATE: '1995-12-21',
      BIRTH_DATE: '1959-05-13',
      EMP_NO: 298545,
      GENDER: 'M',
      RN: 1156,
      LAST_NAME: 'Ponthieu',
      FIRST_NAME: 'Gadiel',
      DEPT_NO: 'd006'
    },
    {
      FROM_DATE: '1988-06-17',
      DEPT_NAME: 'Quality Management',
      SALARY: 53472,
      HIRE_DATE: '1986-06-18',
      TO_DATE: '1988-11-24',
      BIRTH_DATE: '1955-05-04',
      EMP_NO: 298546,
      GENDER: 'M',
      RN: 1162,
      LAST_NAME: 'Werthner',
      FIRST_NAME: 'Shuichi',
      DEPT_NO: 'd006'
    },
    {
      FROM_DATE: '1995-11-05',
      DEPT_NAME: 'Quality Management',
      SALARY: 46540,
      HIRE_DATE: '1985-02-07',
      TO_DATE: '1996-11-04',
      BIRTH_DATE: '1954-01-11',
      EMP_NO: 298547,
      GENDER: 'F',
      RN: 1165,
      LAST_NAME: 'Underwood',
      FIRST_NAME: 'Toshimitsu',
      DEPT_NO: 'd006'
    },
    {
      FROM_DATE: '1994-11-05',
      DEPT_NAME: 'Sales',
      SALARY: 51844,
      HIRE_DATE: '1986-03-24',
      TO_DATE: '1995-11-05',
      BIRTH_DATE: '1959-02-01',
      EMP_NO: 298548,
      GENDER: 'M',
      RN: 1174,
      LAST_NAME: 'Minakawa',
      FIRST_NAME: 'Nagui',
      DEPT_NO: 'd007'
    }

  ]

};
var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
